--
-- Table structure for table `email_templates`
--

CREATE TABLE `email_templates` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(80) NOT NULL,
  `description` text NOT NULL,
  `subject` varchar(80) NOT NULL,
  `content` text NOT NULL,
  `availability` tinyint(4) NOT NULL,
  `creator_id` int(11) NOT NULL default '0',
  `created` date NOT NULL default '0000-00-00',
  `updater_id` int(11) default NULL,
  `updated` date default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Table structure for table `email_schedules`
--

CREATE TABLE `email_schedules` (
  `id` int(11) NOT NULL auto_increment,
  `subject` varchar(80) NOT NULL,
  `content` text NOT NULL,
  `date` datetime NOT NULL,
  `from` varchar(80) NOT NULL,
  `to` varchar(600) NOT NULL,
  `course_id` int(11) default NULL,
  `event_id` int(11) default NULL,
  `grp_id` int(11) default NULL,
  `sent` tinyint(1) NOT NULL default '0',
  `creator_id` int(11) NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Table structure for table `email_merges`
--

CREATE TABLE `email_merges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(80) NOT NULL,
  `value` varchar(80) NOT NULL,
  `table_name` varchar(80) NOT NULL,
  `field_name` varchar(80) NOT NULL,
  `created` datetime NOT NULL,
  `modified` datetime NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `email_merges`
--

INSERT INTO `email_merges` (`id`, `key`, `value`, `field_name`, `created`, `modified`) VALUES
(1, 'Username', '{{{USERNAME}}}', 'username', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(2, 'First Name', '{{{FIRSTNAME}}}', 'first_name', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(3, 'Last Name', '{{{LASTNAME}}}', 'last_name', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(4, 'Email Address', '{{{EMAIL}}}', 'email', '0000-00-00 00:00:00', '0000-00-00 00:00:00');

--
-- Dumping data for table `sys_functions`
--

INSERT INTO `sys_functions` (`id`, `function_code`, `function_name`, `parent_id`, `controller_name`, `url_link`, `permission_type`, `record_status`, `creator_id`, `created`, `updater_id`, `modified`) VALUES
(1700, 'EMAIL_TEMPLATE', 'Email Templates', 0, 'emailtemplates', 'emailtemplates/index', 'AI', 'A', 0, '0000-00-00 00:00:00', NULL, NULL),
(1800, 'EMAIL', 'Emails ', 0, 'emailer', 'emailer/index', 'AI', 'A', 0, '0000-00-00 00:00:00', NULL, NULL);

--
-- Dumping data for table `sys_parameters`
--

INSERT INTO `ipeer`.`sys_parameters` (
`id` ,
`parameter_code` ,
`parameter_value` ,
`parameter_type` ,
`description` ,
`record_status` ,
`creator_id` ,
`created` ,
`updater_id` ,
`modified`
)
VALUES (
NULL , 'email.port', '465', 'S', 'port number for email smtp option', 'A', '0', '2011-07-18 14:23:26', NULL , '2011-07-18 14:23:26'
),
(
NULL , 'email.host', 'ssl://smtp.gmail.com', 'S', 'host address for email smtp option', 'A', '0', '2011-07-18 14:23:26', NULL , '2011-07-18 14:23:26'
),
(
NULL , 'email.username', 'your_username@gmail.com', 'S', 'username for email smtp option', 'A', '0', '2011-07-18 14:23:26', NULL , '2011-07-18 14:23:26'
),
(
NULL , 'email.password', 'your_gmail_password', 'S', 'password for email smtp option', 'A', '0', '2011-07-18 14:23:26', NULL , '2011-07-18 14:23:26'
);